let countdown;
function StartTime() {
    clearInterval(countdown);
    let Hours = parseInt(document.getElementById('Hours').value) || 0;
    let Minutes = parseInt(document.getElementById('Minutes').value) || 0;
    let Seconds = parseInt(document.getElementById('Seconds').value) || 0;
    let totalSeconds = Hours * 3600 + Minutes * 60 + Seconds;
    if (totalSeconds <= 0) return;
    updateDisplay(totalSeconds);
    countdown = setInterval(() => {
        totalSeconds--;
        updateDisplay(totalSeconds);
        if (totalSeconds <= 0) {
            clearInterval(countdown);
            alert('Boom');
            window.close();
        }
    }, 1000);
}

function StopTime() {
    clearInterval(countdown);
}

function updateDisplay(totalSeconds) {
    let DisplayHours = Math.floor(totalSeconds / 3600);
    let DisplayMinutes = Math.floor((totalSeconds % 3600) / 60);
    let DisplaySeconds = totalSeconds % 60;
    document.getElementById('display').innerHTML =
        String(DisplayHours).padStart(2, '0') + ':' + String(DisplayMinutes).padStart(2, '0') + ':' + String(DisplaySeconds).padStart(2, '0');
}
